<?php

namespace Plugins\WidgetBuilder\Widgets;


use App\Facades\GlobalLanguage;
use Plugins\PageBuilder\Fields\Image;
use Plugins\PageBuilder\Fields\Summernote;
use Plugins\PageBuilder\Fields\Text;
use Plugins\WidgetBuilder\WidgetBase;


class TenantHotelBookingAboutUsWidget extends WidgetBase
{
    public function admin_render()
    {
        $output = $this->admin_form_before();
        $output .= $this->admin_form_start();
        $output .= $this->default_fields();

        $widget_saved_values = $this->get_settings();

        $output .= $this->admin_language_tab();
        $output .= $this->admin_language_tab_start();

        $all_languages = GlobalLanguage::all_languages(1);

        foreach ($all_languages as $key => $lang) {
            $output .= $this->admin_language_tab_content_start([
                'class' => $key == 0 ? 'tab-pane fade show active' : 'tab-pane fade',
                'id' => "nav-home-" . $lang->slug
            ]);

            $output .= Text::get([
                'name' => 'title_'.$lang->slug,
                'label' => __('Title'),
                'value' => $widget_saved_values['title_'.$lang->slug] ?? null
            ]);

            $output .= Summernote::get([
                'name' => 'description_'.$lang->slug,
                'label' => __('Description'),
                'value' => $widget_saved_values['description_'.$lang->slug] ?? null
            ]);

            $output .= $this->admin_language_tab_content_end();
        }
        $output .= $this->admin_language_tab_end();

        $output .= Image::get([
            'name' => 'logo_image',
            'label' => __('Logo '),
            'value' => $widget_saved_values['logo_image'] ?? null
        ]);

        $output .= $this->admin_form_submit_button();
        $output .= $this->admin_form_end();
        $output .= $this->admin_form_after();

        return $output;
    }


    public function enable(): bool
    {
        return true; // TODO: Change the autogenerated stub
    }

    public function frontend_render()
    {
        $user_selected_language = get_user_lang();
        $widget_saved_values = $this->get_settings();
        $title = $widget_saved_values['title_' . $user_selected_language] ?? '';
        $description = $widget_saved_values['description_' . $user_selected_language] ?? '';
        $logo_image = $widget_saved_values['logo_image'] ?? '';

        $data = [
            'title' => $title,
            'description' => $description,
            'logo_image' => $logo_image
        ];

        return self::renderView('hotel-booking.tenant_hotel_booking_about_us_widget', $data);
    }

    public function widget_title(){
        return __('Hotel Booking About Us Widget');
    }

    public function columnClass(){
        return 'col-xxl-3 col-xl-3 col-lg-4 col-md-6 col-sm-8';
    }

}
